angular.module('beamng.apps')
.directive('beamGarage', ['$log', function ($log) {
  return {
    templateUrl: '/ui/modules/apps/BeamGarage/app.html',
    replace: true,
    restrict: 'EA',
    controller: ['$scope', function ($scope) {
      // State - Export
      $scope.configJson = '';
      $scope.vehicleModel = '';
      $scope.message = '';
      $scope.copied = false;
      $scope.isExporting = false;
      $scope.hasConfig = false;

      // State - Import
      $scope.importJson = '';
      $scope.importMessage = '';
      $scope.isImporting = false;
      $scope.importSuccess = false;

      // State - Tabs
      $scope.activeTab = 'export';

      // Tab switching
      $scope.switchTab = function(tab) {
        $scope.activeTab = tab;
        $scope.message = '';
        $scope.importMessage = '';
        if (tab === 'export') {
          $scope.message = 'Click Export to get your vehicle config';
        } else {
          $scope.importMessage = 'Paste a config and click Apply';
        }
      };

      // Export function - calls Lua extension
      $scope.exportConfig = function() {
        $scope.message = 'Exporting configuration...';
        $scope.copied = false;
        $scope.isExporting = true;
        $scope.hasConfig = false;
        bngApi.engineLua('extensions.beamGarage_main.exportConfig()');
      };

      // Handle export result from Lua - copy directly to clipboard
      $scope.$on('BeamGarageExportReady', function (event, data) {
        $scope.$evalAsync(function() {
          $scope.vehicleModel = data.model;
          $scope.isExporting = false;

          // Copy directly to clipboard
          navigator.clipboard.writeText(data.config).then(function() {
            $scope.$evalAsync(function() {
              $scope.copied = true;
              $scope.message = 'Copied to clipboard! Paste on BeamGarage.com';
            });
          }).catch(function(err) {
            $scope.$evalAsync(function() {
              $scope.message = 'Failed to copy: ' + err;
            });
          });
        });
      });

      // Handle errors from Lua
      $scope.$on('BeamGarageError', function (event, data) {
        $scope.$evalAsync(function() {
          $scope.configJson = '';
          $scope.message = data.message;
          $scope.isExporting = false;
          $scope.hasConfig = false;
        });
      });

      // Copy to clipboard
      $scope.copyToClipboard = function() {
        if ($scope.configJson) {
          navigator.clipboard.writeText($scope.configJson).then(function() {
            $scope.$evalAsync(function() {
              $scope.copied = true;
              $scope.message = 'Copied! Paste on BeamGarage.com';
            });
          }).catch(function(err) {
            $scope.$evalAsync(function() {
              $scope.message = 'Failed to copy: ' + err;
            });
          });
        }
      };

      // Apply imported config from textarea
      $scope.applyConfig = function() {
        if (!$scope.importJson || !$scope.importJson.trim()) {
          $scope.importMessage = 'Please paste a config first';
          $scope.importSuccess = false;
          return;
        }

        // Basic JSON validation in JS first
        var parsed;
        try {
          parsed = JSON.parse($scope.importJson);
          if (!parsed.model || !parsed.parts) {
            $scope.importMessage = 'Invalid config: missing required fields (model, parts)';
            $scope.importSuccess = false;
            return;
          }
        } catch (e) {
          $scope.importMessage = 'Invalid JSON: ' + e.message;
          $scope.importSuccess = false;
          return;
        }

        $scope.importMessage = 'Applying config...';
        $scope.isImporting = true;
        $scope.importSuccess = false;

        // Base64 encode to avoid escaping issues
        var base64 = btoa(unescape(encodeURIComponent($scope.importJson)));
        bngApi.engineLua("extensions.beamGarage_main.importConfigBase64('" + base64 + "')");
      };

      // Handle import result from Lua
      $scope.$on('BeamGarageImportResult', function (event, data) {
        console.log('[BeamGarage] BeamGarageImportResult received:', data);
        $scope.$evalAsync(function() {
          $scope.isImporting = false;
          if (data.success) {
            $scope.importSuccess = true;
            $scope.importMessage = data.message || 'Config applied successfully!';
            $scope.importJson = ''; // Clear after success
            console.log('[BeamGarage] Import success, message: ' + $scope.importMessage);
          } else {
            $scope.importSuccess = false;
            console.log('[BeamGarage] Import failed, message: ' + (data.message || 'Unknown'));
            $scope.importMessage = 'Error: ' + (data.message || 'Unknown error');
          }
        });
      });

      // Initialize
      $scope.message = 'Click Export to get your vehicle config';
    }]
  };
}]);
