# BeamGarage Mod for BeamNG.drive

Export and import vehicle configurations for BeamGarage.com. Share your builds with the community!

## Installation

### Manual Installation

1. Navigate to your BeamNG.drive mods folder:

   - Windows: `%LOCALAPPDATA%/BeamNG.drive/0.xx/mods/` (replace `0.xx` with your game version)
   - Example: `C:\Users\YourName\AppData\Local\BeamNG.drive\0.32\mods\`

2. Create an `unpacked` folder if it doesn't exist:

   - `%LOCALAPPDATA%/BeamNG.drive/0.xx/mods/unpacked/`

3. Copy the entire `BeamGarage` folder into the `unpacked` folder:

   - Final path: `%LOCALAPPDATA%/BeamNG.drive/0.xx/mods/unpacked/BeamGarage/`

4. Launch BeamNG.drive

### Verify Installation

1. Load any map and spawn a vehicle
2. Press `F11` to enter UI edit mode
3. Click "Add App" and look for "BeamGarage" in the list
4. If you see it, the mod is installed correctly

## Usage

### Adding the App to Your Screen

1. Press `F11` to enter UI edit mode
2. Click "Add App"
3. Find "BeamGarage" in the list and click it
4. Position the app where you want it on screen
5. Press `F11` again to exit edit mode

### Exporting a Vehicle Configuration

1. Spawn and customize your vehicle (change parts, paint, tuning, etc.)
2. Open the BeamGarage app (make sure you're on the "Export" tab)
3. Click the "Export Config" button
4. Your vehicle's configuration will appear in the text area
5. Click "Copy to Clipboard"
6. Go to BeamGarage.com and paste the configuration to share it

### Importing a Vehicle Configuration

1. Copy a vehicle configuration from BeamGarage.com
2. Open the BeamGarage app and click the "Import" tab
3. Paste the JSON configuration into the text area
4. Click "Apply Config"
5. The configuration will be applied to your current vehicle

**Note:** For best results, spawn the same vehicle model that the configuration was created for. If you apply a configuration to a different vehicle model, some parts may not apply correctly.

## Troubleshooting

### "No vehicle spawned" error

- Make sure you have spawned a vehicle before trying to export or import
- Use the vehicle spawner (F7) to spawn a vehicle first

### "No custom configuration found" error

- This can happen if the vehicle is using its default configuration
- Try customizing the vehicle (change a part or paint) and then export again

### "Invalid JSON" error when importing

- Make sure you copied the entire configuration from BeamGarage.com
- The configuration should start with `{` and end with `}`
- Check that there are no extra characters before or after the JSON

### Model mismatch warning

- This appears when you import a configuration for a different vehicle model
- The configuration may still apply, but some parts might not work correctly
- For best results, spawn the matching vehicle model first

### Parts not applying correctly

- Some configurations may use DLC or mod parts that you don't have installed
- Check if the configuration requires any specific DLC or mods

## File Structure

```
BeamGarage/
  README.md             - This file
  lua/ge/extensions/beamGarage/
    main.lua            - Lua extension for export/import logic
  ui/modules/apps/BeamGarage/
    app.html            - UI template
    app.js              - UI controller
    app.json            - App metadata
    app.png             - App icon
```

## Support

For help, feedback, or bug reports, visit [BeamGarage.com](https://beamgarage.com)

## Version History

### 1.0.0

- Initial release
- Export vehicle configurations
- Import vehicle configurations
- Tab-based UI for export/import
- JSON validation and error handling
- Model mismatch warnings
